import { Component, EventEmitter, Output, OnInit } from '@angular/core';

@Component({
  selector: 'app-accountcreate',
  standalone:true,
  templateUrl: './accountcreate.component.html',
  styleUrls: ['./accountcreate.component.css']
})
export class AccountcreateComponent implements OnInit {

  @Output() accountAdded = new EventEmitter<{name: string, status: string}>();

  onCreateAccount(accountName: string, accountStatus: string) {
    this.accountAdded.emit({
      name: accountName,
      status: accountStatus
    });
    console.log('New Account is Created , Account Name: ' + accountName);
  }

  ngOnInit(): void {
      
  }


}
