package com.ashokit.advjpa;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.scheduling.annotation.EnableAsync;

import com.ashokit.advjpa.model.Book;
import com.ashokit.advjpa.model.Employee;
import com.ashokit.advjpa.model.Person;
import com.ashokit.advjpa.model.Publisher;
import com.ashokit.advjpa.service.PersonService;

@SpringBootApplication
@EnableAsync //This Annotation will create a default infrastrucutue for multi threading

public class AdvDataJpaApplication implements CommandLineRunner {

	@Autowired
	private PersonService personService;

	public static void main(String[] args) {
		SpringApplication.run(AdvDataJpaApplication.class, args);
	}

	@Override
	public void run(String... args) throws Exception {
		// createPersons();
		// getPersonByIds();
		// findByLastNameAndFirstName();
		// findByLastNameOrFirstName();
		// findByLastNameOrderByCreatedDateDesc();
		// findByAgeLessThanEqual();
		// findByFirstNameLike();
		// findByLastNameAndAgeLessThanEqual();
		// findByCreatedDateBetweenwithTime();

		// saveBookPublishers();
		//findByBookName();
		//createEmployees();
		//findMaxSalariesbyDept();
		//findPersonInfobyFirstNameorEmail();
		//findPersonINfobyFirstname();
		//dispPagination();
		//runsync();
		runAsync();

	}
	
	
	private void runsync() throws InterruptedException, ExecutionException {

		long start = System.currentTimeMillis();
		// Kick of multiple, asynchronous lookups
		List<Person> person1 = personService.findByEmail("kiran@gmail.com");
		// The following statement will be printed only after the
		// execution of above method findByEmail
		System.out.println("Person1 Call Completed");

		List<Person> personson2 = personService.findByEmail("laxmikiran@gmail.com");
		System.out.println("Person2 Call Completed");

		List<Person> personson3 = personService.findByEmail("sita@gmail.com");
		System.out.println("personson3 Call Completed");

		List<Person> personson4 = personService.findByEmail("lakshman@gmail.com");
		System.out.println("personson4 Call Completed");
		

		
		person1.forEach(System.out::println);
		personson2.forEach(System.out::println);

		personson3.forEach(System.out::println);

		personson4.forEach(System.out::println);

		System.out.println("Total Time took: " + (System.currentTimeMillis() - start));

	}

	private void runAsync() throws InterruptedException, ExecutionException {
		long start = System.currentTimeMillis();
		// Kick of multiple, asynchronous lookups

		// main Thread is executing the runAsynch method
		CompletableFuture<Person> obj1 = personService.findByemail("kiran@gmail.com");
		System.out.println("Person1 Call Done");

		CompletableFuture<Person> obj2 = personService.findByemail("ram@gmail.com");
		System.out.println("Person2 Call Done");

		CompletableFuture<Person> obj3 = personService.findByemail("sita@gmail.com");
		System.out.println("Person3 Call Done");

		CompletableFuture<Person> obj4 = personService.findByemail("lakshman@gmail.com");
		System.out.println("Person4 Call Done"); //This work given to Thrad4  by Main Thread

		///
	 //	1000 lines of code

		//obj2




		// Wait until they are all done
		CompletableFuture.allOf(obj1, obj2, obj3, obj4).join();

		// Print results, including elapsed time

		System.out.println("--> " + obj1.get());
		System.out.println("--> " + obj2.get());
		System.out.println("--> " + obj3.get());
		System.out.println("--> " + obj4.get());

		System.out.println("Elapsed time: " + (System.currentTimeMillis() - start));
	}
	
	private void dispPagination()
	{
		/*

		System.out.println("First Page Without sorting ------------------------");

		List<Person> noSortList = personService.findByLastName("kumar",
				PageRequest.of(0, 4));
		//SELECT * FROM PERSON WHERE LAST_NAME='kumar' WHERE ROWNUMBER>=0 AND RWONUMBER<=4


		noSortList.forEach(System.out::println);

		*/

		
		System.out.println("First Page ------------------------");
		List<Person> list = personService.findByLastName("kumar",
				PageRequest.of(0, 3, Direction.ASC,"firstName"));

		//SELECT * FROM PERSON WHERE LAST_NAME=? WHERE ROWNUMBER>=0 AND RWONUMBER<=4
		 //ORDER BY FIRSTAME ASC;

		//0 -> Offset
		//4 -> Page Size
		//Order of Sorting ASC/DESC
		//Which column Name order

		//for (Person person : list) {
		//	System.out.println("Person Object" + person.toString());
		//}

		list.forEach(System.out::println);


		System.out.println("Second Page ------------------------");
		List<Person> secondlist = personService.findByLastName("kumar",
				//new PageRequest(1, 2, Direction.ASC, "firstName"));
				PageRequest.of(1,3, Direction.ASC, "firstName"));

		secondlist.forEach(System.out::println);


		System.out.println("Third Page ------------------------");
		List<Person> thirdlist = personService.findByLastName("kumar",
				PageRequest.of(2, 3, Direction.ASC,"firstName"));

		thirdlist.forEach(System.out::println);


		System.out.println("Fourth Page ------------------------");
		List<Person> fourthList = personService.findByLastName("kumar",
				PageRequest.of(3, 3, Direction.ASC,"firstName"));

		fourthList.forEach(System.out::println);
		


	}
	
	
	private void findPersonInfobyFirstNameorEmail() {
		Iterable<Person> personsList = personService.findPersonInfobyFirstNameorEmail( "Sita","lakshman@gmail.com");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	private void findPersonINfobyFirstname() {
		Iterable<Person> personsList = personService.findPersonINfobyFirstname( "Sita");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}
	
	private void findMaxSalariesbyDept() {
		System.out.println(" -- finding max salaries in Admin and IT depts  --");
		List<Object[]> list = personService.findMaxSalariesByDept(Arrays.asList("Admin", "IT","HR"));
		list.forEach(arr -> {
			System.out.println(Arrays.toString(arr));
		});
	}
	
	

	private void createEmployees() {

		List<Employee> empList = Arrays.asList(
				Employee.create("Ram", "Admin", 20000),
				Employee.create("Gopi", "Admin", 35000),
				Employee.create("Sita", "Sale", 10000), 
				Employee.create("Ganesh", "Sale", 30000),
				Employee.create("Laxman", "IT", 40000), 
				Employee.create("Seenu", "IT", 25000),
				Employee.create("Swathi", "HR", 80000), 
				Employee.create("Sneha", "HR", 65000)

		);

		Iterable<Employee> list = personService.saveAllEmployees(empList);
		for (Employee emp : list) {
			System.out.println("Employee Object" + emp.toString());

		}
	}

	private void saveBookPublishers() {

		Publisher publisherA = new Publisher("AbdulKalam");
		// insert into tbl_publisher(1,'AbdulKalam');
		Publisher publisherB = new Publisher("Stephen Kovey");
		Publisher publisherC = new Publisher("ChetanBagath");
		Publisher publisherD = new Publisher("Author2");
		Publisher publisherE = new Publisher("Author3");
		Publisher publisherF = new Publisher("Nazir");

		// One Book one Author
		Book bookA = new Book("WingsofFire", new HashSet<>(Arrays.asList(publisherA)));
		// insert into tbl_book(1,'WingsOfFire');
		// insert into book_publishere(1,1);

		Book bookB = new Book("SevenHabits", new HashSet<>(Arrays.asList(publisherB)));
		// insert into tbl_book(2,'SevenHabits');
		// insert into book_publishere(2,2);

		Book bookC = new Book("TwoStates", new HashSet<>(Arrays.asList(publisherC)));
		// insert into tbl_book(3,'TwoStates');
		// insert into book_publishere(3,3);

		// One Book More than one Author
		Book bookD = new Book("Book2", new HashSet<>(Arrays.asList(publisherD, publisherE)));

		// insert into tbl_book(4,'Book2');
		// insert into book_publishere(4,3);
		// insert into book_publishere(4,4);

		// One Author more than one book
		Book bookE = new Book("Book5", new HashSet<>(Arrays.asList(publisherF)));
		Book bookF = new Book("Book6", new HashSet<>(Arrays.asList(publisherF)));

		// insert into tbl_book(5,'Book5');
		// insert into book_publishere(5,5);
		// insert into book_publishere(6,5);

		personService.saveAllBooks(Arrays.asList(bookA, bookB, bookC, bookD, bookE, bookF));

		// bookService.saveBooks(Arrays.asList(bookA, bookB));

		// fetch all publishers
		for (Book book : personService.getAllBooks()) {
			System.out.println(book.toString());
		}

	}

	private void findByBookName() {
		Iterable<Book> booksList = personService.findByBookName("Book2");
		/* tbl_book, tbl_publisher, book_publisher */

		for (Book book : booksList) {
			System.out.println("Book Object" + book.toString());

		}
	}

	private void createPersons() {

		/*
		 * List<Person> personList=new ArrayList<Person>();
		 * 
		 * personList.add(new Person("Kiran", "kumar", "kiran@gmail.com", 20));
		 * 
		 * personList.add(new Person("Kiran1", "kumar", "kiran@gmail.com", 20));
		 * 
		 * personList.add(new Person("Kiran2", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran3", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran4", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran5", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran6", "kumar", "kiran@gmail.com", 20));
		 * personList.add(new Person("Kiran7", "kumar", "kiran@gmail.com", 20));
		 */

		List<Person> personList = Arrays.asList(new Person("Kiran", "kumar", "kiran@gmail.com", 20),
				new Person("Ram", "kumar", "ram@gmail.com", 22),
				new Person("RamKiran", "LaxmiKiran", "sita@gmail.com", 30),
				new Person("Lakshamn", "Seth", "seth@gmail.com", 50),
				new Person("Sita", "Kumar", "lakshman@gmail.com", 50),
				new Person("Ganesh", "Kumar", "ganesh@gmail.com", 50),
				new Person("KiranKiran", "kumar", "kirannew@gmail.com", 20),
				new Person("RamRam", "kumar", "ramnew@gmail.com", 22),
				new Person("RamKiranRamKiran", "LaxmiKiran", "sitanew@gmail.com", 30),
				new Person("RamKiranRamKiran", "Seth", "sethnee@gmail.com", 50),
				new Person("SitaSita", "Kumar", "lakshmannew@gmail.com", 50),
				new Person("GaneshSita", "Kumar", "ganeshnew@gmail.com", 50));

		Iterable<Person> list = personService.saveAllPersons(personList);
		for (Person person : list) {
			System.out.println("Person Object" + person.toString());

		}
	}

	private void getPersonByIds() {
		List<Integer> personList = new ArrayList<Integer>();
		personList.add(1);
		personList.add(2);
		personList.add(12);
		personList.add(5);
		personList.add(6);
		personList.add(20);
		personList.add(40);
		personList.add(11);
		personList.add(15);
		personList.add(3);
		personList.add(4);
		Iterable<Person> personsList = personService.getPersonData(personList);
		// select * from tbl_person where person_id in (1,2,12,5,6,20,40,11,15,3,4);
		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}
	}

	private void findByLastNameAndFirstName() {
		Person person = personService.findByLastNameAndFirstName("kumar", "Ram");
		System.out.println("Person Object" + person.toString());

	}

	private void findByLastNameOrFirstName() {
		Iterable<Person> personsList = personService.findByLastNameOrFirstName("kumar", "Sita");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}

	private void findByLastNameOrderByCreatedDateDesc() {
		Iterable<Person> personsList = personService.findByLastNameOrderByCreatedDateDesc("kumar");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}

	private void findByAgeLessThanEqual() {
		Iterable<Person> personsList = personService.findByAgeLessThanEqual(40);

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}

	private void findByFirstNameLike() {
		Iterable<Person> personsList = personService.findByFirstNameLike("%Kiran%");

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}

	private void findByLastNameAndAgeLessThanEqual() {
		Iterable<Person> personsList = personService.findByLastNameAndAgeLessThanEqual("kumar", 40);

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}

	private void findByCreatedDateBetweenwithTime() {
		// 2024-12-19 06:29:24.873
		Iterable<Person> personsList = personService.findByCreatedDateBetween(getDatewithTime("2024-12-19 06:29:20"),
				getDatewithTime("2024-12-19 06:29:26"));

		for (Person person : personsList) {
			System.out.println("Person Object" + person.toString());

		}

	}

	private Date getDatewithTime(String dateString) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		try {
			return format.parse(dateString);
		} catch (ParseException pe) {
			throw new RuntimeException(pe);
		}
	}
}
