package com.ashokit.advjpa.dao;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;

import com.ashokit.advjpa.model.Person;

@Repository
public interface PersonDao extends JpaRepository<Person, Integer>{
	
	//saveAll and FinallById ==> Available in CrudRepository hence no need to write any code
	
	//Derived Query with Keywords
	
	public Person findByLastNameAndFirstName(String lastName,String firstName);
	//select * from tbl_person where last_name=lastName and first_name=firstName
	
	
	public Iterable<Person> findByLastNameOrFirstName(String lastName,String firstName);
	//select * from tbl_person where last_name=lastName or first_name=firstName
	
	
	public List<Person> findByLastNameOrderByCreatedDateDesc(String lastName);
	//select * from tbl_person where last_name=lastName order by created_date desc
	
	
	
	public List<Person> findByAgeLessThanEqual(Integer age);
	//select * from tbl_person where age<=age;
	
	
	public List<Person> findByFirstNameLike(String firstName);
	//select * from tbl_person where first_name like '%Ram%' Wild Card Search
	
	
	public List<Person> findByLastNameAndAgeLessThanEqual(String lastName,int age);
	//select * from tbl_person where last_name=lastName and age<=age;
	

	public List<Person> findByCreatedDateBetween(Date startdate,Date endDate);


	//Query and Native Query ==> Both Abstract Method and Implementation at Model Layer
	
	//As part of Query and Native Query both Abstract Method and Implementation at Interface Layer itself
	@Query(value="SELECT p FROM Person p where p.firstName=?1 OR p.email=?2")    //Implementation
	List<Person> findPersonInfobyFirstNameorEmail(String firstName,String email); //Abstract Method
	
	
	@Query(value="SELECT * FROM tbl_person p where p.first_name=?1",nativeQuery = true) //Implementation
	List<Person> findPersonINfobyFirstname(String firstName);							//Abstract Method
	
	
	

	//Pagination

	public List<Person> findByLastName(String lastName, Pageable pageable);
		
	List<Person> findByEmail(String email); //Synch Method

	
	@Async
	CompletableFuture<Person> findByemail(String email);  //Asynch Method


	
	

}
