package com.ashokit.advjpa.service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import com.ashokit.advjpa.dao.BookDao;
import com.ashokit.advjpa.dao.EmployeeDao;
import com.ashokit.advjpa.dao.PersonDao;
import com.ashokit.advjpa.model.Book;
import com.ashokit.advjpa.model.Employee;
import com.ashokit.advjpa.model.Person;

@Service
public class PersonService {
	
	@Autowired
	private PersonDao personDao;
	
	
	@Autowired
	private BookDao bookDao;
	
	@Autowired
	private EmployeeDao empDao;
	
	
	public CompletableFuture<Person> findByemail(String email){
		return personDao.findByemail(email);
	}
	
	
	public List<Person> findByEmail(String email){
		return personDao.findByEmail(email);
	}
	
	public List<Person> findByLastName(String lastName, PageRequest pageRequest){
		return personDao.findByLastName(lastName, pageRequest);
	}
	
	//saveAlll
	
	public Iterable<Employee> saveAllEmployees(Iterable<Employee> empList){
		return empDao.saveAll(empList);
	}
	
	public Iterable<Employee> getAllEmployees(){
		return empDao.findAll();
	}
	
	public List<Object[]> findMaxSalariesByDept(List<String> deptNames){
		return empDao.findMaxSalariesByDept(deptNames);
	}
	//saveAll
	
	public Iterable<Book> saveAllBooks(Iterable<Book> booksList)
	{
		return bookDao.saveAll(booksList);
	}
	
	public Iterable<Book> getAllBooks(){
		return bookDao.findAll();
	}
	//SaveAll
	public Iterable<Person> saveAllPersons(Iterable<Person> personsList){
		return personDao.saveAll(personsList);
	}
	public Iterable<Book> findByBookName(String bookName){
		return bookDao.findByBookName(bookName);
	}
	
	
	//findAllById
	public Iterable<Person> getPersonData(List<Integer> personIds){
		return personDao.findAllById(personIds);
	}
	
	public Person findByLastNameAndFirstName(String lastName,String firstName) {
		return personDao.findByLastNameAndFirstName(lastName, firstName);
	}
	
	public Iterable<Person> findByLastNameOrFirstName(String lastName,String firstName){
		return personDao.findByLastNameOrFirstName(lastName, firstName);
	}
	
	public List<Person> findByLastNameOrderByCreatedDateDesc(String lastName){
		return personDao.findByLastNameOrderByCreatedDateDesc(lastName);
	}
	
	
	public List<Person> findByAgeLessThanEqual(Integer age){
		return personDao.findByAgeLessThanEqual(age);
	}
	
	
	public List<Person> findByFirstNameLike(String firstName){
		return personDao.findByFirstNameLike(firstName);
	}
	
	public List<Person> findByLastNameAndAgeLessThanEqual(String lastName,Integer age){
		return personDao.findByLastNameAndAgeLessThanEqual(lastName,age);
	}
	
	public List<Person> findByCreatedDateBetween(Date startdate,Date endDate){
		return personDao.findByCreatedDateBetween(startdate, endDate);
	}
	
	public List<Person> findPersonInfobyFirstNameorEmail(String firstName,String email){
		return personDao.findPersonInfobyFirstNameorEmail(firstName,email);
	}
	
	public List<Person> findPersonINfobyFirstname(String firstName){
		return personDao.findPersonINfobyFirstname(firstName);
	}

}
