package com.ashokit.springboot;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;



/*
 * 
 * 
 * A Java Class which is having @SpringBootApplication Annotation is called as Bootstrap Class
 * 
 * Bootstrap ==> Starting point of Execution
 * 
 * Every Java project should have only one bootstrap class
 * 
 * 
 * Functionality of Boostrap Class
 * 
 * 1) This willl create an IOC Container ==> Inversion of Control Container
 *                                       ==> Framework will take of object managment (Creating,state managment and destruction)
 *                                       ==> IOC will use internally DI (Dependency Injection)
 *                                       
 * 2) AutoScan Capability   ==> This will scan automatically class path and identifies which jar need having autostartup
 *                                              ==> tomcat should start automatically
 *                                              ==> Database Connection should be created automatically
 *                                              ==> Web Application Context should be created automatically
 *                                              
 *                                              
 * 3)Web Application Context ==> Part of IOC ==> But Active Classes will be availble
 *                                           ==> Developer should write Disptacher Servlet Configuration
 *                                           
 *                                           <bean id="orderService" class="com.ashokit.order.OrderService" />
 *                                           ApplicationContext context=new XMLApplicationPathContext(spring.xml)
 *                                       
 * 
 * 
 */
@SpringBootApplication
public class HelloWorldInSpringBootApplication {

	public static void main(String[] args) {
		
		/*
		 * 
		 * By default Spring Boot Framework automatically scans all java files under bootstrap package and boostrap sub package
		 * and pushes to IOC Container
		 * 
		 * com.amazon.order==> Base package
		 * com.amazon.order.*==> All sub packages
		 * 
		 * com.amazon.order.customermodule
		 * com.amazon.order.productmodule
		 * com.amazon.order.inventory
		 * com.aamzon.order.cart
		 * com.amazon.order.payment
		 * com.amaaonz.order.discount
		 * coma.amazon.order.shipment
		 * 
		 */
		SpringApplication.run(HelloWorldInSpringBootApplication.class, args);
	}

}
