package com.ashokit.springboot;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * 
 * We want to expose SBI Bank to Outside world and hence this needs to be registered to Dispatcher Servlet
 * http://localhost:8080/==> Bootstrap level
 * http://localhost:8080/sbi ==> SBIBankImpl obj=ioc.getSBIBankImpl();
 */

@RestController
@RequestMapping(value="/sbi")
public class SBIBankImpl {
	
	
	//Deposits
	@RequestMapping(value = "/deposits")
	//http://localhost:8080/sbi/deposits ==> obj.getDeposits();
	public String getDeposits() {
		return "Deposits functionality invoked";
	}
	
	
	//Withdraws
	@RequestMapping(value = "/withdraw")
	//http://localhost:8080/sbi/withdraw ==> obj.getWithDraws();
	public String getWithDraws() {
		return "WithDraw Functonality Invoked";
	}
	
	
	//HomeLoan
	
	@RequestMapping(value = "/homeloan")
	//http://localhost:8080/sbi/homeloan ==> obj.getHomeLoans();
	public String getHomeloan() {
		return "HomeLoan Functonality Invoked";
	}
	
	
	
	//Personal Loan
	@RequestMapping(value = "/personal")
	//http://localhost:8080/sbi/personal ==> obj.getPersonalLoan();
	public String getPersonalLoan() {
		return "PersonalLoan Functonality Invoked";
	}
	
	
	@RequestMapping(value="/login") //http://localhost:8080/sbi/login ==> obj.getLogin()
	public String getLogin() {
		return "Login Functionality Invoked";
	}

}
