package com.ashokit.ticketbooking;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import com.ashokit.ticketbooking.model.Ticket;
import com.ashokit.ticketbooking.service.TicketService;

@SpringBootApplication
public class TicketBookingApplication implements CommandLineRunner {
	
	//Commnad Line runner ==> When we run our spring boot application , on every execution it will call the run the method once
	
	@Autowired
	private TicketService ticketService;

	public static void main(String[] args) {
		SpringApplication.run(TicketBookingApplication.class, args);
	}

	@Override
	public void run(String... args) throws Exception {
		
		Ticket dummyObj=new Ticket();
		dummyObj.setPassengerName("RAMU");
		dummyObj.setSourceStation("HYDERABAD");
		dummyObj.setDestinationStation("GOA");
		dummyObj.setTravelDate(new Date());
		dummyObj.setEmail("ramu@gmail.com");
		
		ticketService.createTicket(dummyObj);
		
		
	}

}
